function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = World_Economy_Cartel_IRF.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(62, 116);
g1(1,22)=T(29)+T(32);
g1(1,25)=T(29);
g1(1,11)=T(31);
g1(1,39)=exp(y(22))*exp(y(25))*T(74);
g1(1,40)=T(106);
g1(1,43)=T(107);
g1(1,54)=exp(y(22));
g1(1,18)=T(226);
g1(1,20)=T(30)*(-(exp(y(22))*exp(y(43))));
g1(1,75)=(-1);
g1(1,108)=params(21);
g1(2,23)=T(24)*(-exp(y(23)))+exp(y(23))*y(58)+y(68)*(-(T(28)*params(4)*params(4)*exp(y(23)*params(4))));
g1(2,39)=(-exp(y(23)))*T(74);
g1(2,40)=(-exp(y(23)))*T(87);
g1(2,58)=exp(y(23));
g1(2,68)=(-(T(28)*params(4)*exp(y(23)*params(4))));
g1(2,77)=(-1);
g1(2,110)=params(21);
g1(3,24)=y(67)*(-(T(27)*params(4)*params(4)*exp(y(24)*params(4))))+exp(y(24))*y(58)+y(63)*y(35)*T(27)*params(4)*(params(4)-1)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(3,35)=y(63)*T(27)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(3,58)=exp(y(24));
g1(3,63)=y(35)*T(27)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(3,67)=(-(T(27)*params(4)*exp(y(24)*params(4))));
g1(3,76)=(-1);
g1(3,109)=params(21);
g1(4,22)=T(29);
g1(4,25)=T(24)*T(33)+y(71)*(-exp(y(25)))+exp(y(25))*y(70);
g1(4,39)=T(33)*T(74);
g1(4,40)=T(33)*T(87);
g1(4,45)=T(99);
g1(4,52)=T(24)*T(104);
g1(4,70)=exp(y(25));
g1(4,71)=(-exp(y(25)));
g1(4,79)=(-1);
g1(4,112)=params(21);
g1(5,26)=y(71)*(-exp(y(26)))+exp(y(26))*y(69);
g1(5,69)=exp(y(26));
g1(5,71)=(-exp(y(26)));
g1(5,78)=(-1);
g1(5,111)=params(21);
g1(6,27)=T(35);
g1(6,31)=T(41);
g1(6,93)=T(221);
g1(6,98)=params(21)*exp(y(27))*params(6)*exp(params(5)*(y(31)-y(93)));
g1(6,66)=exp(y(27));
g1(6,101)=params(21)*(-(exp(y(27))*(1-exp((-y(93)))*exp(y(31)))));
g1(6,105)=T(228);
g1(7,28)=T(37);
g1(7,32)=T(110);
g1(7,98)=params(21)*params(6)*exp(params(5)*y(32))*exp(y(28));
g1(7,65)=exp(y(28));
g1(7,100)=params(21)*(-((1-exp(y(32)))*exp(y(28))));
g1(7,104)=params(21)*(-(exp(y(32))*exp(y(28))));
g1(8,29)=T(38);
g1(8,66)=(-(params(7)*exp(y(29))));
g1(8,68)=exp(y(29));
g1(8,103)=params(21)*(-((1-params(7))*exp(y(29))));
g1(9,30)=T(39);
g1(9,65)=(-(params(7)*exp(y(30))));
g1(9,67)=exp(y(30));
g1(9,102)=params(21)*(-((1-params(7))*exp(y(30))));
g1(10,27)=T(41);
g1(10,31)=params(21)*y(107)*(-exp(y(31)))+T(113);
g1(10,93)=T(222);
g1(10,98)=params(21)*exp(y(27))*params(6)*params(5)*exp(params(5)*(y(31)-y(93)));
g1(10,101)=T(227);
g1(10,105)=T(228);
g1(10,107)=params(21)*(-exp(y(31)));
g1(11,83)=y(61)*T(108);
g1(11,28)=T(110);
g1(11,32)=T(36)+T(44)+y(64)*exp(y(91))*params(6)*params(5)*(params(5)-1)*(params(5)-1)*exp(y(32)*(params(5)-1))+T(116)+params(21)*y(98)*exp(y(28))*params(6)*params(5)*params(5)*exp(params(5)*y(32));
g1(11,84)=y(61)*(-(exp(y(91))*(-exp(y(32)))));
g1(11,91)=y(64)*T(42)+y(61)*T(43);
g1(11,98)=params(21)*exp(y(28))*params(6)*params(5)*exp(params(5)*y(32));
g1(11,61)=T(43);
g1(11,64)=T(42);
g1(11,100)=params(21)*(-(exp(y(28))*(-exp(y(32)))));
g1(11,104)=params(21)*(-(exp(y(32))*exp(y(28))));
g1(12,33)=exp(y(33))*y(57);
g1(12,57)=exp(y(33));
g1(13,11)=T(30)*y(18)*(-(exp(y(43))*(-exp(y(11)))));
g1(13,43)=T(117);
g1(13,18)=T(30)*(-(exp(y(43))*(1-exp(y(11)))));
g1(13,61)=1;
g1(13,62)=(-params(7));
g1(13,20)=exp(y(43))*T(30);
g1(14,24)=y(63)*T(27)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(14,43)=T(30)*y(19)*(-(exp(y(43))*(1-params(7))));
g1(14,19)=T(30)*(-(exp(y(43))*(1-params(7))));
g1(14,62)=1;
g1(14,63)=params(4)*exp(y(24)*(params(4)-1))*T(27);
g1(15,36)=T(8)*y(71)+y(54)*(-(params(11)*T(12)*T(120)))+y(53)*(-(T(47)*T(124)+params(11)*T(46)*params(11)*T(46)*T(125)));
g1(15,37)=y(54)*(-(T(45)*params(11)*T(48)));
g1(15,13)=y(53)*(-(params(11)*T(46)*T(125)*T(140)));
g1(15,39)=y(53)*(-(params(11)*T(46)*T(84)*T(125)));
g1(15,44)=y(53)*(-(params(11)*T(46)*T(95)*T(125)));
g1(15,53)=(-(params(11)*T(46)*T(47)));
g1(15,54)=(-(params(11)*T(12)*T(45)));
g1(15,71)=T(8);
g1(16,36)=y(54)*(-(T(45)*params(11)*T(48)));
g1(16,37)=y(58)*(-exp(y(37)))+y(56)*(-(T(5)*T(19)*T(16)*exp(T(1)*y(44))*(1-params(11))*params(3)*T(130)))+y(55)*(-(T(17)*T(3)*T(16)*exp(T(1)*y(44))*(1-params(11))*(1-params(3))*T(130)))+exp(y(37))*y(53)+y(54)*(-(T(14)*params(11)*T(130)));
g1(16,13)=y(56)*T(142)+y(55)*(-(T(17)*T(143)));
g1(16,39)=T(131);
g1(16,44)=T(134);
g1(16,53)=exp(y(37));
g1(16,54)=(-(T(14)*params(11)*T(48)));
g1(16,55)=(-(T(17)*T(3)*T(16)*T(50)));
g1(16,56)=(-(T(5)*T(19)*T(16)*T(49)));
g1(16,58)=(-exp(y(37)));
g1(16,80)=(-1);
g1(16,113)=params(21);
g1(17,86)=params(21)*y(94)*(-(T(57)*params(11)*T(126)*T(127)));
g1(17,87)=params(21)*y(95)*(-(T(61)*(T(53)*T(64)*T(136)+T(54)*T(66)*T(136))))+params(21)*y(96)*T(137);
g1(17,38)=T(20)*y(58)+params(21)*y(98)*(-(T(20)*(1-params(10))))+params(21)*y(94)*(-(T(60)*T(156)+T(57)*T(57)*T(127)))+params(21)*y(95)*(-(T(61)*(T(63)*T(64)*T(154)+T(53)*T(63)*T(66)+T(53)*T(63)*T(66)+T(54)*T(63)*T(158))))+params(21)*y(96)*(-(T(52)*(T(66)*T(68)*T(69)+T(67)*T(68)*T(158)+T(66)*T(68)*T(69)+T(64)*T(68)*T(161))))+params(21)*y(97)*(-(exp((1-params(3))*y(88))*exp(T(1)*y(92))*params(3)*params(3)*exp(params(3)*y(38))));
g1(17,88)=params(21)*y(94)*(-(T(60)*T(194)+T(57)*T(127)*T(51)*T(56)*T(54)*T(193)))+params(21)*y(95)*(-((T(53)*T(63)*T(64)+T(54)*T(63)*T(66))*T(195)+T(61)*(T(53)*T(63)*T(65)*T(54)*T(193)+T(54)*T(63)*T(196))))+params(21)*y(96)*(-((T(67)*T(66)*T(68)+T(64)*T(68)*T(69))*T(193)+T(52)*(T(67)*T(68)*T(196)+T(69)*T(68)*T(65)*T(54)*T(193))))+params(21)*y(97)*(-(exp(T(1)*y(92))*params(3)*exp(params(3)*y(38))*(1-params(3))*exp((1-params(3))*y(88))));
g1(17,92)=params(21)*y(94)*(-(T(60)*T(213)+T(57)*T(127)*T(58)*(1-params(11))*T(1)*exp(T(1)*y(92))))+params(21)*y(95)*(-(T(61)*T(215)))+params(21)*y(96)*(-(T(52)*T(216)))+params(21)*y(97)*(-(exp((1-params(3))*y(88))*params(3)*exp(params(3)*y(38))*T(1)*exp(T(1)*y(92))));
g1(17,94)=params(21)*(-(T(57)*T(60)));
g1(17,95)=params(21)*(-(T(61)*(T(53)*T(63)*T(64)+T(54)*T(63)*T(66))));
g1(17,96)=params(21)*T(70);
g1(17,97)=params(21)*(-(exp((1-params(3))*y(88))*exp(T(1)*y(92))*params(3)*exp(params(3)*y(38))));
g1(17,58)=T(20);
g1(17,98)=params(21)*(-(T(20)*(1-params(10))));
g1(18,22)=exp(y(22))*exp(y(25))*T(74);
g1(18,23)=(-exp(y(23)))*T(74);
g1(18,25)=T(33)*T(74);
g1(18,36)=y(53)*(-(T(84)*params(11)*T(46)*T(125)));
g1(18,37)=T(131);
g1(18,13)=y(57)*(-(T(75)*exp(T(1)*y(44))*params(3)*exp(y(13)*params(3))))+y(56)*(-(T(77)*(T(19)*T(18)*T(78)*T(139)+T(16)*T(18)*T(141))+T(5)*(T(18)*T(79)*T(141)+T(19)*T(18)*T(145))))+y(55)*(-(T(17)*(T(15)*T(79)*T(138)+T(3)*T(15)*T(145))+T(81)*T(146)))+y(53)*(-(T(84)*T(125)*T(140)+T(47)*T(148)));
g1(18,14)=y(60)*T(166);
g1(18,39)=(T(33)-exp(y(23)))*T(173)+y(60)*(-(params(1)*T(173)/T(26)))+T(4)*y(59)+y(57)*(-(exp(T(1)*y(44))*exp(y(13)*params(3))*(1-params(3))*T(75)))+y(56)*T(178)+y(55)*T(182)+y(53)*(-(T(84)*T(84)*T(125)+T(47)*T(183)))+params(21)*y(99)*T(185);
g1(18,88)=params(21)*y(99)*(-((-(T(74)*T(200)))/(T(24)*T(24))));
g1(18,15)=y(60)*T(201);
g1(18,40)=(T(33)-exp(y(23)))*T(203)+y(60)*(-(params(1)*T(203)/T(26)))+params(21)*y(99)*T(205);
g1(18,89)=params(21)*y(99)*(-((-(T(74)*params(1)*exp(y(89))*T(199)))/(T(24)*T(24))));
g1(18,44)=y(57)*(-(T(75)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))))+T(189)+T(190)+y(53)*(-(T(47)*T(191)+T(84)*T(95)*T(125)));
g1(18,45)=T(192);
g1(18,52)=T(74)*T(104);
g1(18,53)=(-(T(47)*T(84)));
g1(18,55)=T(82);
g1(18,56)=T(80);
g1(18,57)=T(76);
g1(18,59)=T(4);
g1(18,60)=(-(params(1)*T(74)/T(26)));
g1(18,99)=params(21)*(-((-(T(74)*T(86)))/(T(24)*T(24))));
g1(19,22)=T(106);
g1(19,23)=(-exp(y(23)))*T(87);
g1(19,25)=T(33)*T(87);
g1(19,14)=y(60)*T(167);
g1(19,39)=(T(33)-exp(y(23)))*T(186)+y(60)*(-(params(1)*T(186)/T(26)))+params(21)*y(99)*(-(T(187)/T(184)));
g1(19,88)=params(21)*y(99)*(-((-(T(87)*T(200)))/(T(24)*T(24))));
g1(19,15)=y(60)*T(202);
g1(19,40)=(T(33)-exp(y(23)))*T(206)+y(60)*(-(params(1)*T(206)/T(26)))+exp(y(40))*y(58)+params(21)*y(99)*(-((T(24)*T(24)*(-(T(86)*T(206)))-(-(T(86)*T(87)))*T(204))/T(184)));
g1(19,89)=params(21)*y(99)*(-((-(T(87)*params(1)*exp(y(89))*T(199)))/(T(24)*T(24))));
g1(19,45)=T(87)*T(98);
g1(19,52)=T(87)*T(104);
g1(19,58)=exp(y(40));
g1(19,60)=T(88);
g1(19,99)=params(21)*(-((-(T(86)*T(87)))/(T(24)*T(24))));
g1(20,41)=exp(y(41))*y(56)+T(89);
g1(20,43)=T(89);
g1(20,56)=exp(y(41));
g1(20,17)=T(30)*(-(exp(y(41))*exp(y(43))));
g1(21,42)=exp(y(42))*y(55)+y(59)*(-(T(21)*T(209)));
g1(21,55)=exp(y(42));
g1(21,59)=(-(T(21)*T(90)));
g1(22,22)=T(107);
g1(22,11)=T(114);
g1(22,34)=T(117);
g1(22,35)=T(30)*y(19)*(-(exp(y(43))*(1-params(7))));
g1(22,41)=T(89);
g1(22,43)=T(91);
g1(22,17)=T(30)*(-(exp(y(43))*(1+exp(y(41))-params(10))));
g1(22,60)=exp(y(43));
g1(22,18)=T(30)*(-(exp(y(43))*(exp(y(22))*exp(y(11))+y(34)*(1-exp(y(11)))-params(6)*exp(params(5)*y(11)))));
g1(22,19)=T(30)*(-(y(35)*exp(y(43))*(1-params(7))));
g1(22,20)=T(30)*(exp(y(43))*params(6)*params(5)*exp(y(11)*(params(5)-1))-exp(y(43))*(exp(y(22))-y(34)));
g1(23,36)=y(53)*(-(T(95)*params(11)*T(46)*T(125)));
g1(23,37)=T(134);
g1(23,13)=y(57)*T(149)+y(56)*(-(T(5)*T(150)))+y(55)*(-(T(17)*T(151)))+y(53)*(-(T(95)*T(125)*T(140)+T(47)*T(94)*T(83)*T(139)));
g1(23,39)=y(57)*(-(T(75)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))))+T(189)+T(190)+y(53)*(-(T(95)*T(84)*T(125)+T(47)*T(191)));
g1(23,44)=y(57)*T(210)+y(56)*(-(T(5)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(44))))+y(55)*T(211)+y(53)*(-(T(95)*T(95)*T(125)+T(47)*T(212)));
g1(23,53)=(-(T(47)*T(95)));
g1(23,55)=(-(T(17)*T(3)*T(16)*T(93)));
g1(23,56)=(-(T(5)*T(19)*T(16)*T(92)));
g1(23,57)=(-(exp(y(39)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))));
g1(23,73)=1;
g1(23,106)=params(21)*(-params(15));
g1(23,114)=T(96)*(-params(16));
g1(24,25)=T(99);
g1(24,6)=T(103);
g1(24,10)=T(111);
g1(24,39)=T(192);
g1(24,40)=T(87)*T(98);
g1(24,45)=T(24)*T(218)+T(219);
g1(24,52)=T(24)*T(224);
g1(24,58)=T(102);
g1(24,66)=T(101);
g1(24,70)=T(100);
g1(24,72)=1;
g1(25,75)=1;
g1(26,76)=1;
g1(27,77)=1;
g1(28,78)=1;
g1(29,79)=1;
g1(30,80)=1;
g1(31,25)=T(24)*T(104);
g1(31,39)=T(74)*T(104);
g1(31,40)=T(87)*T(104);
g1(31,45)=T(24)*T(220);
g1(31,52)=exp(y(52))*y(74)+T(24)*T(225);
g1(31,74)=exp(y(52));
g1(32,36)=(-(params(11)*T(46)*T(47)));
g1(32,37)=exp(y(37));
g1(32,13)=(-(T(47)*T(140)));
g1(32,39)=(-(T(47)*T(84)));
g1(32,44)=(-(T(47)*T(95)));
g1(33,22)=exp(y(22));
g1(33,36)=(-(params(11)*T(12)*T(45)));
g1(33,37)=(-(T(14)*params(11)*T(48)));
g1(34,37)=(-(T(17)*T(3)*T(16)*T(50)));
g1(34,13)=(-(T(17)*T(146)));
g1(34,39)=T(82);
g1(34,42)=exp(y(42));
g1(34,44)=(-(T(17)*T(3)*T(16)*T(93)));
g1(35,37)=(-(T(5)*T(19)*T(16)*T(49)));
g1(35,13)=(-(T(5)*(T(19)*T(18)*T(78)*T(139)+T(16)*T(18)*T(141))));
g1(35,39)=T(80);
g1(35,41)=exp(y(41));
g1(35,44)=(-(T(5)*T(19)*T(16)*T(92)));
g1(36,33)=exp(y(33));
g1(36,13)=(-(exp(y(39)*(1-params(3)))*exp(T(1)*y(44))*params(3)*exp(y(13)*params(3))));
g1(36,39)=T(76);
g1(36,44)=(-(exp(y(39)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))));
g1(37,23)=exp(y(23));
g1(37,24)=exp(y(24));
g1(37,6)=params(6)*exp(params(5)*(y(10)-y(45)))*exp(y(6));
g1(37,7)=params(6)*exp(params(5)*y(11))*exp(y(7));
g1(37,10)=exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(45)));
g1(37,11)=exp(y(7))*params(6)*params(5)*exp(params(5)*y(11));
g1(37,37)=(-exp(y(37)));
g1(37,13)=(-(exp(y(13))*(1-params(10))));
g1(37,38)=T(20);
g1(37,40)=exp(y(40));
g1(37,45)=T(102);
g1(38,39)=T(4);
g1(38,42)=(-(T(21)*T(90)));
g1(39,90)=(-(exp(y(91))*exp(y(90))));
g1(39,91)=(-(exp(y(91))*(1+exp(y(90))-params(10))));
g1(40,14)=(-((-(params(1)*T(24)*T(165)))/(T(26)*T(26))));
g1(40,39)=(-(params(1)*T(74)/T(26)));
g1(40,15)=(-((-(params(1)*T(24)*exp(y(15))*T(164)))/(T(26)*T(26))));
g1(40,40)=T(88);
g1(40,43)=exp(y(43));
g1(41,83)=T(108);
g1(41,32)=T(43);
g1(41,34)=1;
g1(41,84)=(-(exp(y(91))*(1-exp(y(32)))));
g1(41,91)=(-(exp(y(91))*(exp(y(32))*exp(y(83))+(1-exp(y(32)))*y(84)-params(6)*exp(params(5)*y(32)))));
g1(42,34)=(-params(7));
g1(42,35)=1;
g1(42,85)=(-(exp(y(91))*(1-params(7))));
g1(42,91)=(-(exp(y(91))*(1-params(7))*y(85)));
g1(43,24)=y(35)*T(27)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(43,35)=params(4)*exp(y(24)*(params(4)-1))*T(27);
g1(44,83)=(-(exp(y(91))*exp(y(83))));
g1(44,32)=T(42);
g1(44,84)=exp(y(91));
g1(44,91)=T(105);
g1(45,7)=(-(exp(y(7))*(1-exp(y(11)))));
g1(45,28)=exp(y(28));
g1(45,30)=(-(params(7)*exp(y(30))));
g1(45,11)=(-(exp(y(7))*(-exp(y(11)))));
g1(46,6)=(-(exp(y(6))*(1-exp((-y(45)))*exp(y(10)))));
g1(46,27)=exp(y(27));
g1(46,29)=(-(params(7)*exp(y(29))));
g1(46,10)=T(112);
g1(46,45)=T(101);
g1(47,24)=(-(T(27)*params(4)*exp(y(24)*params(4))));
g1(47,9)=(-((1-params(7))*exp(y(9))));
g1(47,30)=exp(y(30));
g1(48,23)=(-(T(28)*params(4)*exp(y(23)*params(4))));
g1(48,8)=(-((1-params(7))*exp(y(8))));
g1(48,29)=exp(y(29));
g1(49,26)=exp(y(26));
g1(49,7)=(-(exp(y(7))*exp(y(11))));
g1(49,11)=(-(exp(y(7))*exp(y(11))));
g1(50,25)=exp(y(25));
g1(50,6)=T(109);
g1(50,10)=T(109);
g1(50,45)=T(100);
g1(51,25)=(-exp(y(25)));
g1(51,26)=(-exp(y(26)));
g1(51,36)=T(8);
g1(52,45)=1;
g1(52,115)=(-1);
g1(53,16)=(-params(15));
g1(53,44)=1;
g1(53,116)=(-1);
g1(53,21)=(-params(16));
g1(54,10)=(-exp(y(10)));
g1(54,52)=exp(y(52));
g1(55,1)=1;
g1(55,22)=(-1);
g1(55,46)=1;
g1(56,3)=1;
g1(56,24)=(-1);
g1(56,47)=1;
g1(57,2)=1;
g1(57,23)=(-1);
g1(57,48)=1;
g1(58,5)=1;
g1(58,26)=(-1);
g1(58,49)=1;
g1(59,4)=1;
g1(59,25)=(-1);
g1(59,50)=1;
g1(60,12)=1;
g1(60,37)=(-1);
g1(60,51)=1;
g1(61,106)=(-1);
g1(61,81)=1;
g1(62,16)=(-1);
g1(62,82)=1;

end
